#!/bin/sh
#
# This script fixes vmotion export version of VMware DFW filters after
# upgrading from NSX 6.1.x to NSX 6.2.4, so that the associated VMs can
# be vmotioned to other hosts without being disconnected.
# 
# Copyright 2016 @ VMware Inc.

if [ "${1}" = "" ]; then
    echo "Usage: ${0} <path_to_custom_vsipioctl_binary>"
    exit 1
elif [ ! -x ${1} ]; then
    echo "${1} does not appear to be a vsipioctl executable"
    exit 1
fi

# Get the current VIB version to make sure script is executed only on hosts 
# upgraded to NSX-v 6.2.3 or higher release
VIB_VERSION=$(esxcli software vib list | grep vsip | awk -F "-0.0." '{print $2}' | awk -F " " '{print $1}')
VIB_VERSION_LOW=3960641
VIB_VERSION_HIGH=4259819
if [ $VIB_VERSION -ge $VIB_VERSION_LOW -a $VIB_VERSION -le $VIB_VERSION_HIGH ]; then

    VSIPIOCTL="${1}"
    for filter in `summarize-dvfilter | grep vmware-sfw.2 | awk '{print $NF}' | xargs`; do
    	CURVER=`${VSIPIOCTL} getexportversion -f ${filter} | grep "Current export version" | awk '{print $NF}'` 

    	if [ $? -ne 0 ] || [ "${CURVER}" = "" ]; then
        	echo "Failed to get export version of filter ${filter}"
        	continue
    	fi
    	if [ "${CURVER}" = "2" ]; then
        	${VSIPIOCTL} setexportversion -f ${filter} -e 4 > /dev/null
        	if [ $? -ne 0 ]; then
            		echo "ERROR: failed to fix filter ${filter} export version."
        	else
            		echo "Fixed filter ${filter} export version to 4."
        	fi
    	elif [ "${CURVER}" = "3" ]; then
        	echo "Filter ${filter} has export version ${CURVER}, no changes required."
    	else
    		echo "Filter ${filter} already has export version ${CURVER}"
    	fi
    done
else
	echo "Script cannot be executed on this host, please make sure the host is upgraded to NSX-v 6.2.3 or higher release"
fi 
